/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.util.fe.idl;

import com.visigenic.vbroker.util.fe.idl.ASTLiteral;
import com.visigenic.vbroker.util.fe.idl.ASTScopedName;
import com.visigenic.vbroker.util.fe.idl.IDLParser;
import com.visigenic.vbroker.util.fe.idl.Manager;
import com.visigenic.vbroker.util.fe.idl.Node;
import com.visigenic.vbroker.util.fe.idl.ParseException;
import com.visigenic.vbroker.util.fe.idl.SimpleNode;
import org.omg.CORBA.IDLType;
import org.omg.CORBA.PrimitiveKind;
import org.omg.CORBA.Repository;

public class ASTType
extends SimpleNode {
    private IDLType _type;
    private ASTScopedName _name;

    ASTType(int n) {
        super(n);
    }

    ASTType(IDLParser iDLParser, int n) {
        super(iDLParser, n);
    }

    void initType(ASTType aSTType) {
        this._type = aSTType._type;
        this._name = aSTType._name;
    }

    void initKind(Repository repository, PrimitiveKind primitiveKind) throws ParseException {
        this._type = repository.get_primitive(primitiveKind);
    }

    void initString(Repository repository, ASTLiteral aSTLiteral) throws ParseException {
        this._type = repository.create_string(aSTLiteral.toPositiveInteger());
    }

    void initWstring(Repository repository, ASTLiteral aSTLiteral) throws ParseException {
        this._type = repository.create_wstring(aSTLiteral.toPositiveInteger());
    }

    void initSequence(Manager manager, ASTType aSTType, ASTLiteral aSTLiteral) throws ParseException {
        int n = 0;
        if (aSTLiteral != null) {
            n = aSTLiteral.toPositiveInteger();
        }
        this._type = manager.ir().create_sequence(n, aSTType.type(manager));
    }

    void initType(IDLType iDLType) {
        this._type = iDLType;
    }

    void initScopedName(ASTScopedName aSTScopedName) {
        this._name = aSTScopedName;
    }

    IDLType type(Manager manager) throws ParseException {
        if (this._type == null) {
            manager.typeFromScopedName(this, this._name);
        }
        return this._type;
    }

    Object value() {
        if (this._type != null) {
            return this._type;
        }
        return this._name;
    }

    public static Node jjtCreate(int n) {
        return new ASTType(n);
    }

    public static Node jjtCreate(IDLParser iDLParser, int n) {
        return new ASTType(iDLParser, n);
    }
}

